	function [G, Z, P] = STEP_INVARIANT(G, Z, P, T)

	%	Computes the poles and zeros for a step response-invariant 
	%	filter from an analog lowpass filter. 
	%	T is the sample period. 
	%	The band edge for a digital lowpass filter is approximately 
	%	wcT which should be << pi in order to not have too large aliasing.

	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Lars Wanhammar 2010-09-10
	% 	Modified by: 	 	
	% 	Copyright:		by authors - not released for commercial use
	% 	Version:		1	 
	% 	Known bugs:		
	% 	Report bugs to:	Wanhammar@gmail.com
	
	N = length(P);
	PY = exp([P; 0].*T);
	denum = ROOTS_2_POLY(PY);
	t_axis = [0:T:2*N*T];
	[s_of_t, t_axis] = PZ_2_STEP_RESPONSE_S(G, Z, P, t_axis);
	P = exp(P.*T);
	N = length(PY); 
	Hn = toeplitz(s_of_t(1:N+1), [s_of_t(1) zeros(1, N)]);
	numer = Hn*denum';
	numer(1) = [];
	numer(end) = [];	
	Z = roots(numer);
	G =	numer(1);
